/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseReason;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.utils.Holder;
import org.glassfish.grizzly.utils.NullaryFunction;

public class TCPNIOConnection
extends NIOConnection {
    private static final Logger LOGGER = Grizzly.logger(TCPNIOConnection.class);
    Holder<SocketAddress> localSocketAddressHolder;
    Holder<SocketAddress> peerSocketAddressHolder;
    private int readBufferSize = -1;
    private int writeBufferSize = -1;
    private AtomicReference<ConnectResultHandler> connectHandlerRef;

    public TCPNIOConnection(TCPNIOTransport transport, SelectableChannel channel) {
        super(transport);
        this.channel = channel;
    }

    @Override
    protected void setSelectionKey(SelectionKey selectionKey) {
        super.setSelectionKey(selectionKey);
    }

    @Override
    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        super.setSelectorRunner(selectorRunner);
    }

    @Override
    protected void preClose() {
        this.checkConnectFailed(null);
        super.preClose();
    }

    protected boolean notifyReady() {
        return this.connectCloseSemaphor.compareAndSet(null, NOTIFICATION_INITIALIZED);
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.peerSocketAddressHolder.get();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localSocketAddressHolder.get();
    }

    protected void resetProperties() {
        if (this.channel != null) {
            this.setReadBufferSize(this.transport.getReadBufferSize());
            this.setWriteBufferSize(this.transport.getWriteBufferSize());
            int transportMaxAsyncWriteQueueSize = ((TCPNIOTransport)this.transport).getAsyncQueueIO().getWriter().getMaxPendingBytesPerConnection();
            this.setMaxAsyncWriteQueueSize(transportMaxAsyncWriteQueueSize == -2 ? this.getWriteBufferSize() * 4 : transportMaxAsyncWriteQueueSize);
            this.localSocketAddressHolder = Holder.lazyHolder(new NullaryFunction<SocketAddress>(){

                @Override
                public SocketAddress evaluate() {
                    return ((SocketChannel)TCPNIOConnection.this.channel).socket().getLocalSocketAddress();
                }
            });
            this.peerSocketAddressHolder = Holder.lazyHolder(new NullaryFunction<SocketAddress>(){

                @Override
                public SocketAddress evaluate() {
                    return ((SocketChannel)TCPNIOConnection.this.channel).socket().getRemoteSocketAddress();
                }
            });
        }
    }

    @Override
    public int getReadBufferSize() {
        if (this.readBufferSize >= 0) {
            return this.readBufferSize;
        }
        try {
            this.readBufferSize = ((SocketChannel)this.channel).socket().getReceiveBufferSize();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, LogMessages.WARNING_GRIZZLY_CONNECTION_GET_READBUFFER_SIZE_EXCEPTION(), e);
            this.readBufferSize = 0;
        }
        return this.readBufferSize;
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        if (readBufferSize > 0) {
            try {
                int currentReadBufferSize = ((SocketChannel)this.channel).socket().getReceiveBufferSize();
                if (readBufferSize > currentReadBufferSize) {
                    ((SocketChannel)this.channel).socket().setReceiveBufferSize(readBufferSize);
                }
                this.readBufferSize = readBufferSize;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTION_SET_READBUFFER_SIZE_EXCEPTION(), e);
            }
        }
    }

    @Override
    public int getWriteBufferSize() {
        if (this.writeBufferSize >= 0) {
            return this.writeBufferSize;
        }
        try {
            this.writeBufferSize = ((SocketChannel)this.channel).socket().getSendBufferSize();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, LogMessages.WARNING_GRIZZLY_CONNECTION_GET_WRITEBUFFER_SIZE_EXCEPTION(), e);
            this.writeBufferSize = 0;
        }
        return this.writeBufferSize;
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        if (writeBufferSize > 0) {
            try {
                int currentSendBufferSize = ((SocketChannel)this.channel).socket().getSendBufferSize();
                if (writeBufferSize > currentSendBufferSize) {
                    ((SocketChannel)this.channel).socket().setSendBufferSize(writeBufferSize);
                }
                this.writeBufferSize = writeBufferSize;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTION_SET_WRITEBUFFER_SIZE_EXCEPTION(), e);
            }
        }
    }

    protected final void setConnectResultHandler(ConnectResultHandler connectHandler) {
        this.connectHandlerRef = new AtomicReference<ConnectResultHandler>(connectHandler);
    }

    protected final void onConnect() throws IOException {
        ConnectResultHandler localConnectHandler;
        AtomicReference<ConnectResultHandler> localRef = this.connectHandlerRef;
        if (localRef != null && (localConnectHandler = (ConnectResultHandler)localRef.getAndSet(null)) != null) {
            localConnectHandler.connected();
            this.connectHandlerRef = null;
        }
        TCPNIOConnection.notifyProbesConnect(this);
    }

    protected final void checkConnectFailed(Throwable failure2) {
        ConnectResultHandler localConnectHandler;
        AtomicReference<ConnectResultHandler> localRef = this.connectHandlerRef;
        if (localRef != null && (localConnectHandler = (ConnectResultHandler)localRef.getAndSet(null)) != null) {
            if (failure2 == null) {
                failure2 = new IOException("closed");
            }
            localConnectHandler.failed(failure2);
            this.connectHandlerRef = null;
        }
    }

    @Override
    protected void terminate0(CompletionHandler<Closeable> completionHandler, CloseReason closeReason) {
        super.terminate0(completionHandler, closeReason);
    }

    protected final void onRead(Buffer data, int size2) {
        if (size2 > 0) {
            TCPNIOConnection.notifyProbesRead(this, data, size2);
        }
        this.checkEmptyRead(size2);
    }

    protected final void onWrite(Buffer data, long size2) {
        TCPNIOConnection.notifyProbesWrite(this, data, size2);
    }

    @Override
    public boolean canWrite() {
        return this.transport.getWriter(this).canWrite(this);
    }

    @Override
    @Deprecated
    public boolean canWrite(int length) {
        return this.transport.getWriter(this).canWrite(this);
    }

    @Override
    public void notifyCanWrite(WriteHandler writeHandler) {
        this.transport.getWriter(this).notifyWritePossible(this, writeHandler);
    }

    @Override
    @Deprecated
    public void notifyCanWrite(WriteHandler handler, int length) {
        this.transport.getWriter(this).notifyWritePossible(this, handler);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TCPNIOConnection");
        sb.append("{localSocketAddress=").append(this.localSocketAddressHolder);
        sb.append(", peerSocketAddress=").append(this.peerSocketAddressHolder);
        sb.append('}');
        return sb.toString();
    }

    protected static interface ConnectResultHandler {
        public void connected() throws IOException;

        public void failed(Throwable var1);
    }
}

